#define LM35 A5                 // Broche LM35
byte segmente[10]= {B01000000,  // 0
                    B01111001,  // 1
                    B00100100,  // 2
                    B00110000,  // 3
                    B00011001,  // 4
                    B00010010,  // 5
                    B00000010,  // 6
                    B01111000,  // 7
                    B00000000,  // 8
                    B00010000}; // 9 
int shiftPin = 8;      // SH_CP 
int storagePin = 9;  // ST_CP
int dataPin = 10;    // DS

// Fonction de transmission des informations
void sendeBytes(int value) {
    digitalWrite(storagePin, LOW);
    shiftOut(dataPin, shiftPin, MSBFIRST, value >> 8); 
    shiftOut(dataPin, shiftPin, MSBFIRST, value & 255); 
    digitalWrite(storagePin, HIGH);
}

void displayValue(int value) {
  byte tens = int(value / 10);    // Calculer le chiffre des dizaines
  byte units = value - tens * 10; // Calculer le chiffre des unités
  sendeBytes(segmente[tens] << 8 | segmente[units]);  // Dizaines et unités
}

void setup() {
  Serial.begin(9600);
  pinMode(shiftPin, OUTPUT);
  pinMode(storagePin, OUTPUT);
  pinMode(dataPin, OUTPUT);  
}

void loop() {
  int analogValue = analogRead(LM35);
  int temperature = (5.0 * 100.0 * analogValue) / 1024;
  displayValue(temperature);      // Afficher la valeur
  Serial.println(temperature); // Envoi à l'interface série
  delay(500);                  // Courte pause
}
